############################################################
### Utilitaire de création d'un nouveau fichier molécule ###
############################################################


import os

os.chdir("C:/Users/Louis/Desktop/TIPE/fichiers_molecules")

nom = input("Nom de la molécule : ")

### Sécurité pour éviter de détruire un fichier existant

try:
    f = open(nom + '.py', 'r')
    print("Fichier déjà existant")

### Si la molécule n'existe pas déjà, on la crée

except FileNotFoundError:
    f = open(nom + ".py", 'w')
    f.write("import classes\n\n")

    # On commence par demander le nombre d'atomes dans la molécule
    
    n_at = int(input("Nombre d'atomes dans la molécule : "))

    # On se renseigne sur les atomes (nature, voisins)
    
    for i in range(1, n_at + 1):
        nat = input("Atome " + str(i) + " ; nature de l'atome (C, H, O, etc) : ")
        n_vois = int(input("Nombre de voisins : "))
        l_vois = []
        for j in range(n_vois):
            l_vois.append(int(input("Numéro voisin (1 à la fois) : ")))
        f.write("atome" + str(i) + " = classes.Atome('" + nat + "', " + str(i) + ", " + str(l_vois) + ")\n")

    f.write("\n")

    # On crée les tableaux de coefficients des OM

    f.write("tableau_coeffs_HO = classes.Tableau_de_coefficients([")

    # Boucle d'écriture automatique de la première partie du tableau

    for i in range(1, n_at):
        f.write("atome" + str(i) + ", ")
    f.write("atome" + str(n_at) + "], [")

    # Demande (puis écriture) des coefficients des atomes dans la HO

    for i in range(1, n_at):
        f.write(input("Coefficient HO de l'atome " + str(i) + " : ") + ", ")
    f.write(input("Coefficient HO de l'atome " + str(n_at) + " : ") + "])\n\n")

    # Même démarche pour la BV
    
    f.write("tableau_coeffs_BV = classes.Tableau_de_coefficients([")

    for i in range(1, n_at):
        f.write("atome" + str(i) + ", ")
    f.write("atome" + str(n_at) + "], [")

    for i in range(1, n_at):
        f.write(input("Coefficient BV de l'atome " + str(i) + " : ") + ", ")
    f.write(input("Coefficient BV de l'atome " + str(n_at) + " : ") + "])\n\n")

    # Demande (puis écriture) des énergies orbitalaires
    
    f.write("HO = classes.Orbitale_moleculaire(")
    f.write(input("Energie de la HO : "))
    f.write(", tableau_coeffs_HO, 'HO')\n\n")

    f.write("BV = classes.Orbitale_moleculaire(")
    f.write(input("Energie de la BV : "))
    f.write(", tableau_coeffs_BV, 'BV')\n\n")

    f.write("molecule = classes.Molecule('" + nom + "', HO, BV)")

    f.close()

    print("Molécule enregistrée")    
