###Définition des classes pour le logiciel de test réactionnel

##Classe atome, qui va gérer l'organisation de la molécule

class Atome:
    '''Définition de la classe Atome'''

    def __init__(self, nature, numero, voisins):
        self.nature = nature
        self.numero = numero
        self.voisins = voisins

    def valence(self):
        '''Renvoie la valence de l'atome considéré'''
        return(len(self.voisins))

    def nature_lettres(self):
        '''Renvoie la nature de l'atome en toutes lettres et en minuscules, précédé de "de".'''
        if self.nature == 'C':
            return('de carbone')
        elif self.nature == 'H':
            return('''d'hydrogène''')
        elif self.nature == 'O':
            return("d'oxygène")
        elif self.nature == 'Br':
            return('de brome')
        elif self.nature == 'Cl':
            return('de chlore')
        elif self.nature == 'N':
            return('''d'azote''')
        else:
            return('erreur : atome non défini')
            



##Classe tableau de coefficients, qui va contenir les coefficients des atomes
##d'une orbitale moléculaire

class Tableau_de_coefficients:
    '''Définition de la classe Tableau_de_coefficients'''

    def __init__(self, liste_atomes, liste_coefficients):
        '''Constructeur du tableau de coefficients'''
        self.couple_atome_coeff = [0]
        for i in range(len(liste_atomes)):
            self.couple_atome_coeff.append([liste_atomes[i], liste_coefficients[i]])


##Classe orbitale moléculaire, contenant énergie de l'orbitale et tableau
##de coefficients

class Orbitale_moleculaire:
    '''Définition de la classe Orbitale_moleculaire'''

    def __init__(self, energie, tableau_de_coefficients, nature):
        '''Constructeur de l'orbitale moléculaire'''
        self.energie = energie
        self.tableau_de_coeffs = tableau_de_coefficients
        self.nature = nature # Nature : HO ou BV


##Classe molécule, qui va contenir le nom de la molécule et les informations
##sur ses orbitales HO et BV

class Molecule:
    '''Définition de la classe Molecule'''

    def __init__(self, nom, HO, BV):
        '''Constructeur de la molecule'''
        self.nom = nom
        self.HO = HO
        self.BV = BV
