#########################################
### Création de la fenêtre "A propos" ###
#########################################

import tkinter

# La fonction qui sera appelée par le programme principal pour
# afficher la fenêtre.

def principale(rien):
    '''Affiche la fenêtre renseignant sur la conception du programme.'''
    f_apropos = tkinter.Toplevel()
    f_apropos.focus_force()
    f_apropos.title("À propos")

    espace1 = tkinter.Frame(f_apropos, height = 20)
    espace1.grid(row = 0, column = 0)
    
    cadre_bodin = tkinter.Frame(f_apropos)
    cadre_bodin.grid(row = 1, column = 0)
    pre_image_bodin = tkinter.PhotoImage(file = "images/photo_bodin.gif")
    fond_bodin = tkinter.Canvas(cadre_bodin, width = 100, height = 129, bg = 'black')
    fond_bodin.pack()
    image_bodin = fond_bodin.create_image(52,66, image = pre_image_bodin)
    tkinter.Label(cadre_bodin, text = "Jean-Baptiste Bodin").pack()


    cadre_peault = tkinter.Frame(f_apropos, width = 200)
    cadre_peault.grid(row = 1, column = 1)
    pre_image_peault = tkinter.PhotoImage(file = "images/photo_peault.gif")
    fond_peault = tkinter.Canvas(cadre_peault, width = 100, height = 129, bg = 'black')
    fond_peault.pack()
    image_peault = fond_peault.create_image(52,66, image = pre_image_peault)
    tkinter.Label(cadre_peault, text = "Louis Péault").pack()

    espace = tkinter.Frame(f_apropos, height = 20)
    espace.grid(row = 2, column = 0)

    texte = """Ce programme a été réalisé par Louis Péault \
et Jean-Baptiste Bodin, élèves de classe préparatoire \
(filière PC) au lycée Clemenceau, dans le cadre de l'épreuve de TIPE.\n
Ce programme a pour but de prédire des réactions de chimie organique \
sous contrôle orbitalaire, il indique les interactions \
les plus probables entre les atomes des différentes molécules.\n
Les coefficients orbitalaires utilisés sont extraits de \
la base de données Orbimol : P. Chaquin et F. Fuster, \
OrbiMol, Laboratoire de Chimie Théorique, UPMC Univ Paris \
06- UMR CNRS 7616, Paris."""


    widget_texte = tkinter.Label(f_apropos, text = texte, wraplength = 400, anchor=tkinter.W, justify=tkinter.LEFT)
    widget_texte.config(padx = 5, pady = 5)
    widget_texte.grid(row = 3, column = 0, columnspan = 2)
    
    f_apropos.resizable(width = False, height = False)
    f_apropos.mainloop()
